-- v 251106A
local TICKS = 1 -- To slow down processing, increase this number
--==================================================================================
do -- A QUERTY'ish Keyboard by Draken35
  local keyMatrix = {
    { "@<#>","Load Wpts" },
    { "~","!", "@", "#", "$", "%", "^", "&", "*", "(", ")","_","+","|", "⌫" ,"7","8","9"},
    { "`","1", "2", "3", "4", "5", "6", "7", "8", "9", "0","-","=", ";", "'", ",","4","5","6"},
    { "[","]","Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "{","}","\\",".","1","2","3" },
    { "CAPS","A", "S", "D", "F", "G", "H", "J", "K", "L", ":","\"","/", "↩", "00","⌫X"},
    { "Shift","Z", "X", "C", "V", "B", "N", "M", "<", ">", "?","°","␣"  },

   
  } 
  local width = 30
  local height = 30
  local capsOn = false
  local shift = false

  addButton(0, 0, 50, 30, "CLR", function(text)
    text:setText("")
  end)


  local y = 30
  for _, r in pairs(keyMatrix) do
    local x = 0
    for k, v in pairs(r) do
      local title = v
      local char = v
      if type(v) == "table" then
        title, char = pairs(v)(v)
      end
      local onClick = function(text)
        text:insert(char)
      end
      if string.byte(char) >= 65 and string.byte(char) <= 90 then
        onClick = function(text)
          if capsOn or shift then
            text:insert(char)
            if shift then
              shift = false
            end
          else
            text:insert(string.char(string.byte(char)+32))
          end
        end
      end
    
      if v == "⌫" then
        onClick = function(text)
          text:deleteBackward()
        end
        width = 60
      elseif v == "⌫X" then
        onClick = function(text)
          text:deleteBackward()
        end
         title = "⌫"
        width = 30      
      elseif v == "↩" then
        onClick = function(text)
           text:insert("\n")
          end
        width = 60
      elseif v == "CLR" then
        onClick = function(text)
          text:setText("")
        end
        width = 60
      elseif v == "␣" then
        onClick = function(text)
          text:insert(" ")
        end
        width = 180--480   
      elseif v == "CAPS" then
        onClick = function(text)
            capsOn = not capsOn
          end
        width = 60     
      elseif v == "Shift" then
        onClick = function(text)
            shift = not shift
          end
        width = 60     
      elseif v == "00" then
        title = "0"
        onClick = function(text)
            text:insert("0")
          end
        width = 60     
      elseif v == "@<#>" then
        onClick = function(text)
            text:insert("@<#>")
          end
        width = 60        
      elseif v == "@[#]" then
        onClick = function(text)
            text:insert("@<#>")
          end
        width = 60        
     elseif v == "Load Wpts" then
        onClick = function(text)
          insertCoords(text)
        end
        width = 180--480      
        x = 390
      else
        width = 30
    end
    
      addButton(x, y, width, height, title, onClick)

      x = x + width
    end
    if width > 30 then
      width = 30
    end
    y = y + width
  end


end -- keyboard
--==================================================================================
 -- Coordinates loading... the magic happens here
local tick_counter = 0
local doLoadCoords = false 
local inputBuffer = {}
local dataIndex = 1
local counterFrame = 0
local doDepress = false


local handler = {}
function handler.onSimulationFrame()
  tick_counter = tick_counter + 1
  if tick_counter == TICKS then
    tick_counter = 0
    if doLoadCoords == true then 
        ProcessInputBuffer()
    end
  end
end -- function
DCS.setUserCallbacks(handler)
--==================================================================================
addCoordinateListener(
  function (text, lat, lon, alt, mgrs, types)

    local ac = DCS.getPlayerUnitType()
    local insert = ""
    log('Adding coordinates for '..ac) 
    if ac == "FA-18C_hornet" then
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."|"
    elseif ac == "F-16C_50"  then
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."|" 
    elseif ac == "M-2000C"  then
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."|" 
    elseif ac == "AV8BNA" then
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."|"   
    elseif ac == "F-15ESE" then 
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."|"  
    elseif ac == "AH-64D_BLK_II" then
      insert = "@|#|"..formatCoord("MGRS", nil, mgrs, types.MGRS) .. "|" ..string.format("%.0f", alt*3.28084).."||"  
    elseif ac == "A-10C_2" or ac == "A-10C" then  
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"..string.format("%.0f", alt*3.28084).."||"  
    elseif ac == "Mirage-F1EE"  then
      types.DDM = {precision = 1}
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"   
    elseif ac == "OH58D" then
      insert = "@|#|"..formatCoord("MGRS", nil, mgrs, types.MGRS) .. "|" ..string.format("%.0f", alt).."|"       
    elseif ac == "CH-47Fbl1" then
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"--..string.format("%.0f", alt*3.28084).."|"      
    elseif string.find(ac,"SA342")  then
      types.DDM = {precision = 1}
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"    
    elseif string.sub(ac,1,5) == "Ka-50"  then
      types.DDM = {precision = 1,lonDegreesWidth= 3}
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."|"           
    elseif (ac == "UH-60L" or ac == "UH-60L_DAP") then -- Add new branches for UH-60L,UH-60L_DAP
      insert = "@|#|"..formatCoord("DDM", true, lat, types.DDM) .. "|" .. formatCoord("DDM", false, lon, types.DDM).."||" -- Format the coordinates in DDM for these H-60       
    elseif ac == 'AJS37' then
      types.DMS = {precision = 0, noLeadingZero = true}
      insert = "@|#|"..formatCoord("DMS", false, lon, types.DMS) .. "|" .. formatCoord("DMS", true, lat, types.DMS).."|||"
    else
      log('Adding coordinates for '..ac..' not possible') 
    end
    
    text:insertBelow(insert)
  end -- function
) --addCoordinateListener
--==================================================================================
function insertCoords(text)
  local StartWaypoint = 1
  local Waypoints = {}
  local wpi = 0 
  local lc = 0
  local ac = DCS.getPlayerUnitType()
  local role = DCS.getUnitProperty(DCS.getPlayerUnit(),DCS.UNIT_ROLE)
  --local ExtraDelay = 0
  
  for LINE in string.gmatch(text:getText(),"([^\n]*)\n?") do    
    local line = LINE:gsub("^%s*(.-)%s*$", "%1"):upper()
    local L = string.len(line)
    local tokens = {}
    local lineType = 'WP'
    local separator = '|'
    local ti = 0
    lc = lc + 1
    if (string.sub(line,1,2) == "@<" or string.sub(line,1,2) == "@|") and L > 2 then
      if string.sub(line,1,2) == "@<" then
        lineType = 'SWP'
        separator = '>'    
     --   log('Found @<')
      end
      if string.sub(line,1,2) == "@[" then
        lineType = 'DEL'
        separator = ']'         
    --    log('Found @[')        
      end
      local temp = ''
      for i = 3,L do
        local c = string.sub(line,i,i)
        if c ~= separator then
          temp = temp..c
        end
        if (i == L or c == separator) and  temp ~= '' then
          ti = ti + 1
          tokens[ti] = temp
          temp = ''
        end
      end   -- for i = 3,L do      
      if lineType == 'DEL' and #tokens == 1 then
        TICKS = tokens[1]
    --    log('TICKS set to: '.. tokens[1])
      end
      if lineType == 'SWP' and #tokens == 1 then
        StartWaypoint = tokens[1]
      end
	    if lineType == 'WP' and (#tokens == 3 or #tokens == 4) and (ac == 'UH-60L' or ac ==  "UH-60L_DAP") then -- Additional branch for H-60 aircraft variants 
        wpi = wpi + 1
        if #tokens == 4 then -- Extracting waypoint data for H60
			    Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3], name = tokens[4]}
		    else
			    Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3], name = ''}
		    end
      end
      if lineType == 'WP' and #tokens == 4 and ac ~= 'AH-64D_BLK_II' and  ac ~= "A-10C_2" and ac ~= "A-10C" and ac ~= "UH-60L" and ac ~=  "UH-60L_DAP" then
        wpi = wpi + 1
        Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3], alt = tokens[4] }
      end
      if lineType == 'WP' and  (#tokens == 3 or #tokens == 4) and ac == 'AH-64D_BLK_II' then
        wpi = wpi + 1
        if #tokens == 4 then
          Waypoints[wpi] = {des = tokens[1], mgrs = tokens[2], alt = tokens[3], free = tokens[4]}
        else       
          Waypoints[wpi] = {des = tokens[1], mgrs = tokens[2], alt = tokens[3], free = ''}        
        end
      end
      if lineType == 'WP' and  (#tokens == 4 or #tokens == 5) and (ac == "A-10C_2" or ac == "A-10C") then
        wpi = wpi + 1
        if #tokens == 5 then
          log(ac..' 5 tokens') 
          Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3], alt = tokens[4], name = tokens[5]}
        else      
          log(ac..' 4 tokens') 
          Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3], alt = tokens[4], name = ''}         
        end
      end      
      if lineType == 'WP' and  #tokens == 3 and (ac == 'Mirage-F1EE' or  string.find(ac,"SA342") or string.sub(ac,1,5) == "Ka-50"  ) then
        wpi = wpi + 1
        Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3]}
      end      
      if lineType == 'WP' and  (#tokens == 3 ) and ac == 'OH58D' then
        wpi = wpi + 1       
        Waypoints[wpi] = {des = tokens[1], mgrs = tokens[2], alt = tokens[3]}     
      end
      if lineType == 'WP' and  (#tokens == 3 ) and ac == 'CH-47Fbl1' then
        wpi = wpi + 1       
        Waypoints[wpi] = {des = tokens[1], lat = tokens[2], lon = tokens[3]}        
      end
      if ac == 'AJS37' then
        wpi = wpi + 1   
        if #tokens == 3 then
          Waypoints[wpi] = {des = tokens[1], lon = tokens[2], lat = tokens[3]}        
        elseif #tokens == 5 then 
          Waypoints[wpi] = {des = tokens[1], lon = tokens[2], lat = tokens[3], brg = tokens[4], rng = tokens[5]}  
        end
      end

    end -- if (string.sub(line,1,2) == "@<" or string.sub(line,1,2) == "@<") and L > 2 then
  end --   for line in string.gmatch(text:getText(),"([^\n]*)\n?") do
  if wpi > 0 then
    loadCoordinates(StartWaypoint,Waypoints)
  end
 return true
end -- function
--==================================================================================    
function loadCoordinates(StartWaypoint,Waypoints)--, ExtraDelay)
   -- ExtraDelay = ExtraDelay
    local ac = DCS.getPlayerUnitType()
    local role = DCS.getUnitProperty(DCS.getPlayerUnit(),DCS.UNIT_ROLE)
    log('loadCoordinates --> '..ac..' ('..role..')')   
  
    if ac == "AV8BNA" then
      loadInAV8B(StartWaypoint,Waypoints)
    elseif ac == "F-15ESE"  then
      local device = 57
      if role == 'Pilot' then
        device = 56
      end
      loadInF15E(StartWaypoint,Waypoints,device)
    elseif ac == "A-10C_2" or ac == "A-10C" then
      loadInA10(StartWaypoint,Waypoints)
    elseif ac == "FA-18C_hornet"  then
      loadInF18(StartWaypoint,Waypoints) 
    elseif ac == "M-2000C" then
      loadInM2000(StartWaypoint,Waypoints)
    elseif ac == "Mirage-F1EE" then
      loadInF1EE(StartWaypoint,Waypoints)      
    elseif ac == "F-16C_50" then
      loadInF16(StartWaypoint,Waypoints)
    elseif  ac == 'AH-64D_BLK_II' then
      local seat = 'CPG'
      if role == 'Pilot' then
        seat = 'PLT'
      end
      loadInApache(StartWaypoint,Waypoints,seat)      
    elseif  ac == 'OH58D' then
      local seat = 'CPG'
      if role == 'Pilot' then
        seat = 'PLT'
      end
      loadInKW(StartWaypoint,Waypoints,seat)      
    elseif ac == "UH-60L" or ac == "UH-60L_DAP" then -- Add a conditional branch for H-60 variants
      loadInH60(StartWaypoint,Waypoints) -- Call the loadInH60 function for H-60 aircraft variants     
    elseif  ac == 'CH-47Fbl1' then
      local seat = 'LEFT'
      if role == 'Pilot' then
        seat = 'RIGHT'
      end
      loadInHook(StartWaypoint,Waypoints,seat)    
    elseif string.find(ac,"SA342") then
      loadInGazelle(StartWaypoint,Waypoints)
    elseif string.sub(ac,1,5) == "Ka-50"  then
      loadInBlackShark(StartWaypoint,Waypoints)
  elseif ac == "AJS37"  then
      loadInViggen(StartWaypoint,Waypoints)      
    end
  end -- function
--==================================================================================
function clicOn(device, code, delay, position, keyTXT )
  keyTXT = keyTXT or ''
  delay = delay or 0
  position = position or 1
  local datas ={device, code, delay, position}
  table.insert(inputBuffer,datas)
  log('clicOn('..device..','.. code..','.. delay..','.. position..'): '..keyTXT)
end -- function
--==================================================================================
function ProcessInputBuffer()  
--  log("running ProcessInputBuffer with "..#inputBuffer .." entries.")
  for i = dataIndex, #inputBuffer do
      if not doDepress then 
          if inputBuffer[i][1] ~= -1 then
            Export.GetDevice(inputBuffer[i][1]):performClickableAction(inputBuffer[i][2],inputBuffer[i][4])
          end
          if inputBuffer[i][3] >0 then 
              doDepress = true
          else 
              if inputBuffer[i][4] == 1 or inputBuffer[i][4] == -1 then 
                if inputBuffer[i][1] ~= -1 then
                  Export.GetDevice(inputBuffer[i][1]):performClickableAction(inputBuffer[i][2],0)
                  --   log('pos: '..inputBuffer[i][4] )
                end
              end
              dataIndex = dataIndex+1
          end
      else
          if counterFrame >= tonumber(inputBuffer[i][3]) then 
              dataIndex = dataIndex+1
              counterFrame = 0
              if inputBuffer[i][4] == 1 or inputBuffer[i][4] == -1 then 
                if inputBuffer[i][1] ~= -1 then                
                  Export.GetDevice(inputBuffer[i][1]):performClickableAction(inputBuffer[i][2],0)
                end
              end
              doDepress =false
          else 
              counterFrame = counterFrame+1
              
          end
      end

      break
  end

  if dataIndex == table.getn(inputBuffer)+1 then
      doLoadCoords = false
      dataIndex=1
      counterFrame =0
      doDepress =false
  end

end -- function
--==================================================================================
function loadInAV8B(start,waypoints)
    local delay = 10
    inputBuffer = {}
    local isWP = true
    --                        0      1      2       3      4     5       6      7      8      9 
    local correspondance = {'3315','3302','3303','3304','3306','3307','3308','3310','3311','3312'}

    --[[
        L18 main menu
        L2 EHSD
        L2 DATA
        ODU-1 WPT
        UFC @wp_counter
        UFC ENTER
        ODU-2 POS
        UFC loop (ends on enter)
        ODU-3 ELEV
        alt loop (ends on enter)
        L2 DATA
    --]]
    log('>>>>>>>>>>>>> AV8B Load Start <<<<<<<<<<<<<<')
    clicOn(26,"3217",delay)   -- MCPD L18 - Main Menu
    log('[MCPD L18 - Main Menu]')
    clicOn(26,"3201",delay)   -- MCPD L2 -  EHSD
    log('[MCPD L2 -  EHSD]')
    clicOn(26,"3201",delay)   -- MCPD L2 -  DATA
    log('[MCPD L2 -  DATA]')
    local wpn = start - 1
    for i, v in ipairs(waypoints) do
      local swpn = ''
      if v.des == '#' then
        wpn = wpn + 1 
        swpn =  tostring(wpn)
        isWP = true
       log(string.format('>>>>> Using WP counter#: %s',swpn))
      else
        if string.sub(v.des,1,1) == 'T' then
          isWP = false
          swpn =  tostring(string.sub(v.des,2,string.len(v.des)))
          log(string.format('>>>>> Using WP des#: %s',swpn))      
        else
          isWP = true
          swpn =  tostring(v.des)
          log(string.format('>>>>> Using WP des#: %s',swpn))
        end
      end
      
      --log(string.format('>>>>> Load coords in WP#:%s',swpn))
      if not isWP then -- it is a targetPoint
        clicOn(24,"3250",delay)   --  ODU-1 WPT
        log('[ODU-1]')
        clicOn(24,"3250",delay)   --  ODU-1 WPT
        log('[ODU-1]')
      end
      
      for k = 1, swpn:len() do
        local ci = tonumber(swpn:sub(k,k))+1
        local btn =  correspondance[ci]
        clicOn(23,btn,delay) -- UFC number
        log(string.format('[UFC number: %s]',ci))
      end
      clicOn(23,"3314",delay) -- UFC ENTER
      log('[UFC ENTER]')
      clicOn(24,"3251",delay)   --  ODU-2 POS
      log('[ODU-2 POS]')

      for iii, digits in ipairs({v.lat,v.lon}) do
        for ii = 1,string.len(digits) do 
            local vv = string.sub(digits,ii,ii)
            if vv == "N" then 
                clicOn(23,"3303",delay)
                log('[UFC number: 2|N]')
            elseif  vv == "S" then 
                clicOn(23,"3311",delay)
                log('[UFC number: 8|S]')
            elseif vv == "E" then 
                clicOn(23,"3308",delay)
                log('[UFC number: 6|E]')
            elseif vv == "W" then                 
                clicOn(23,"3306",delay)
                log('[UFC number: 4|W]')
            elseif vv == "." then                 
                clicOn(23,"3316",delay)
                log('[UFC dot')                
            elseif ( vv == "'"  or vv == '"' or vv == "°"  or vv == " ") then 
              -- ignore
            else            
                local position = tonumber(vv)
                if position ~=nil then 
                    position = position+1
                    if (correspondance[position] ~= nil) then 
                        clicOn(23,correspondance[position],delay)
                        log(string.format('[UFC number: %s]',vv))
                    end
                end
            end
        end
          clicOn(23,"3314",delay) -- UFC ENTER
          log('[UFC ENTER]')
        end

        clicOn(24,"3252",delay)   --  ODU-3 ALT
        log('[ODU-3 ALT]')
        for ii = 1,string.len(v.alt) do 
            local vv = string.sub(v.alt,ii,ii)
            local position = tonumber(vv)
            if position ~=nil then 
                position = position+1
                if (correspondance[position] ~= nil) then 
                  clicOn(23,correspondance[position],delay)
                  log(string.format('[UFC number: %s]',vv))
                end
            end
        end
        clicOn(23,"3314",delay) -- UFC ENTER
        log('[UFC ENTER]')

        clicOn(24,"3250",delay)   --  ODU-1 WPT
        log('[ODU-1]')
        if not isWP then -- it is a targetPoint
          clicOn(24,"3250",delay)   --  ODU-1 WPT
          log('[ODU-1')
        end
  

    end
    clicOn(26,"3201",delay)   -- MCPD L2 -  DATA
  --  log('[MCPD L2 -  DATA]')

    doLoadCoords = true
    --log('>>>>>>>>>>>>> AV8B Load END <<<<<<<<<<<<<<')
  end
--==================================================================================
function loadInF15E(start,waypoints,device)
  local deviceF15 = device --56
  local delay = 8 -- 15

  --log("in f15")

  local correspondances = {  --0 to 9
      '3036','3020','3021','3022','3025','3026','3027','3030','3031','3032'
  }
  
  local textCorrepondance = {  
      ['A'] = "3020",
      ['B'] = "3022",
      ['C'] = "3032",
      ['M'] = "3036",
      
}

  local commande = {
      ['accessSTR'] = "3010",
      ['shift'] = "3033", 
      ["changeWPT"] = "3001",
      ["addToLat"] = "3002",
      ["addToLong"] = "3003",
      ["addToAlt"] = "3007",
      ["north"] = "3021",
      ["south"] = "3031",
      ["east"] = "3027",
      ["west"] = "3025",
      ["CLR"] = "3035",
      ["Menu"] = "3038",
  }

  inputBuffer = {} 

  f15route = 'A'
  local l = string.len(start)
  local r = string.sub(start,l,l)
  if r == 'A' or r == 'B' or r == 'C' then
    f15route = r
    if l == 1 then
      start = 1
    else
      start = string.sub(start,1,l-1)
    end
  end
  
  f15Number = start - 1

  clicOn(deviceF15, commande.CLR, delay)
  clicOn(deviceF15, commande.CLR, delay)
  clicOn(deviceF15, commande.Menu, delay)

  clicOn(deviceF15, commande.accessSTR, delay)

  for i, v in ipairs(waypoints) do
      local wptPosition = ''
      if v.des == '#' then
        f15Number = f15Number + 1 
        wptPosition =  tostring(f15Number)..f15route
      --  log(string.format('>>>>> Using WP counter#: %s',wptPosition))
      elseif v.des == '#.' then
        f15Number = f15Number + 1 
        wptPosition =  tostring(f15Number)..'.'..f15route
      else
        wptPosition =  tostring(v.des)
    --    log(string.format('>>>>> Using WP des#: %s',wptPosition))
      end
   
      for ii = 1,string.len(wptPosition) do
          local vv = string.sub(wptPosition,ii,ii)
          if (vv == ".") then 
              clicOn(deviceF15, "3029",delay) -- targetpoint (dot)
          elseif (vv == "A") then 
            clicOn(deviceF15, commande.shift,delay)
            clicOn(deviceF15, textCorrepondance["A"],delay)        
          elseif (vv == "B") then 
            clicOn(deviceF15, commande.shift,delay)
            clicOn(deviceF15, textCorrepondance["B"],delay)  
          elseif (vv == "C") then 
            clicOn(deviceF15, commande.shift,delay)
            clicOn(deviceF15, textCorrepondance["C"],delay)      
          elseif (vv == "M") then 
            clicOn(deviceF15, commande.shift,delay)
            clicOn(deviceF15, textCorrepondance["M"],delay)               
          else 
              local position = tonumber(vv)
              if position ~=nil then 
                  position = position+1
                  if (correspondances[position] ~= nil) then 
                      clicOn(deviceF15,correspondances[position],delay)
                  end
              end
          end
      end

      clicOn(deviceF15, commande.changeWPT, delay)

      for iii, keys in ipairs({v.lat,v.lon,v.alt}) do
          for ii = 1, string.len(keys) do 
              local vv = string.sub(keys,ii,ii)
              if vv == "N" then 
                  clicOn(deviceF15, commande.shift,delay)
                  clicOn(deviceF15, commande.north,delay)
               --   log('>>>>> press N')
              elseif  vv == "S" then 
                  clicOn(deviceF15, commande.shift,delay)
                  clicOn(deviceF15, commande.south,delay)
              --    log('>>>>> press S')                    
              elseif vv == "E" then 
                  clicOn(deviceF15, commande.shift,delay)
                  clicOn(deviceF15, commande.east,delay)
               --   log('>>>>> press E')                    
              elseif vv == "W" then 
                  clicOn(deviceF15, commande.shift,delay)
                  clicOn(deviceF15, commande.west,delay)
               --   log('>>>>> press W')                    
              elseif(vv == "." or vv == "'"  or vv == '"' or vv == "°"  or vv == " ")  then 
              --    log('>>>>> ignored')
              else            
                  local position = tonumber(vv)
                  if position ~=nil then 
                      position = position+1
                      if (correspondances[position] ~= nil) then 
                          clicOn(deviceF15,correspondances[position],delay)
                 --         log('>>>>> press '..vv)
                      end
                  end
              end
          end
          if (iii == 1) then 
              clicOn(deviceF15, commande.addToLat,delay)
            --  log('>>>>> press LAT')
          elseif (iii == 2)  then 
              clicOn(deviceF15, commande.addToLong,delay)
            --  log('>>>>> press LONG')
          else 
              clicOn(deviceF15, commande.addToAlt,delay)
           --   log('>>>>> press ALT')
          end
      end
  end

  doLoadCoords = true
  
end
--==================================================================================
function loadInF18(start,waypoints)
    local delay = 15
    local delayLong = 50 
    local delayShort = 5 
    local indexCoords = {
        "lat","long"
    }
    inputBuffer = {}
    local correspondance = {'3018','3019','3020','3021','3022','3023','3024','3025','3026','3027'}
    clicOn(37,"3028",delay) 
    clicOn(37,"3028",delay)
    clicOn(37,"3012",delay)
    clicOn(37,"3020",delay)
   -- clicOn(37,"3022",20)
    for i, v in ipairs(waypoints) do
       -- clicOn(37,"3022",20)
        -- if firstInsertion then 
            -- clicOn(37,"3022",20)
            -- firstInsertion = false
        -- end

        clicOn(37,"3015",delay)
        clicOn(25,"3010",delay)
      
        for iii, digits in ipairs({v.lat,v.lon}) do
          for ii = 1,string.len(digits) do 
                local vv = string.sub(digits,ii,ii)
                if vv == "N" then 
                    clicOn(25,"3020",delay)
                elseif  vv == "S" then 
                    clicOn(25,"3026",delay)
                elseif vv == "E" then 
                    clicOn(25,"3024",delay)
                elseif vv == "W" then 
                    clicOn(25,"3022",delay)
                elseif (vv == "." or vv == "'") then -- Enter
                    clicOn(25,"3029",delayLong)
                elseif (vv == '"' or vv == "°"  or vv == " ") then
                else            
                    local position = tonumber(vv)
                    if position ~=nil then 
                        position = position+1
                        if (correspondance[position] ~= nil) then 
                            clicOn(25,correspondance[position],delayShort)
                        end
                    end
                end
            end
            
        end

        clicOn(25,"3012",delay)
        clicOn(25,"3010",delay)
        for ii = 1,string.len(v.alt) do 
            local vv = string.sub(v.alt,ii,ii)
            local position = tonumber(vv)
            if position ~=nil then 
                position = position+1
                if (correspondance[position] ~= nil) then 
                    clicOn(25,correspondance[position],delayShort)
                end
            end
        end
        clicOn(25,"3029",delayLong)

       clicOn(37,"3022",delay)
    end
     clicOn(37,"3020",delay)
    doLoadCoords = true
end
--==================================================================================
function loadInM2000(start,waypoints)
    local delay = 10
    inputBuffer = {}
    --local d35firstIns = true
    local correspondance = {'3593',     '3584','3585','3586','3587','3588','3589','3590','3591','3592'}
    log('>>>>>>>>>>>>> M-2000C Load Start <<<<<<<<<<<<<<')
    for i, v in ipairs(waypoints) do
        clicOn(9,"3574",delay,0.4) -- INS_PARAM_SEL 3
        clicOn(9,"3570",delay)
        clicOn(9,"3570",delay)
        clicOn(9,"3584",delay)
        for iii, digits in ipairs({v.lat,v.lon}) do
          for ii = 1,string.len(digits) do 
                local vv = string.sub(digits,ii,ii)
                if vv == "N" then 
                    clicOn(9,"3585",delay)
                elseif vv == "E" then
                    clicOn(9,"3589",delay)
                elseif vv == "S" then
                    clicOn(9,"3591",delay)
                elseif vv == "W" then
                    clicOn(9,"3587",delay)
                elseif vv == "'" then 
                    clicOn(9,"3596",delay)
                    if iii == 1 then -- LAT
                        clicOn(9,"3586",delay)
                    end
                elseif (vv == "."  or vv == '"' or vv == "°"  or vv == " " or vv == "'") then 
                else
                    local position = tonumber(vv)
                    if position ~=nil then 
                        position = position+1
                        if (correspondance[position] ~= nil) then 
                            clicOn(9,correspondance[position],delay)
                        end
                    end
                end
            end
        end
        clicOn(9,"3574",delay,0.3)
        clicOn(9,"3584",delay)
        clicOn(9,"3584",delay)
        for ii = 1,string.len(v.alt) do 
            local vv = string.sub(v.alt,ii,ii)
            local position = tonumber(vv)
            if position ~=nil then 
                position = position+1
                if (correspondance[position] ~= nil) then 
                    clicOn(9,correspondance[position],delay)
                end
            end
        end
        clicOn(9,"3596",delay)
        clicOn(9,"3110",delay)   -- INS_NEXT_WP_BTN
    end 
    clicOn(9,"3574",delay,0.4)
    
    doLoadCoords = true
end
--==================================================================================
function loadInF16(start,waypoints)
    local delay = 5--10
    inputBuffer = {}

    local correspondance = {'3002','3003','3004','3005','3006','3007','3008','3009','3010','3011','3027'}

    clicOn(17,"3032",delay+10, -1)--ICP_DATA_RTN_SEQ_SW 0
    clicOn(17,"3006",delay) --ICP_BTN_4
    local wpn = start - 1
    for i, v in ipairs(waypoints) do
        -- select wp
        local swpn = ''
        if v.des == '#' then
          wpn = wpn + 1 
          swpn =  tostring(wpn)
         log(string.format('>>>>> Using WP counter#: %s',swpn))
        else
           swpn =  tostring(v.des)
          log(string.format('>>>>> Using WP des#: %s',swpn))         
        end
        -- enter the wpn number
        for k = 1, swpn:len() do
          local ci = tonumber(swpn:sub(k,k))+1
          local btn =  correspondance[ci]
          clicOn(17,btn,delay) -- UFC number
          log(string.format('[UFC number: %s]',ci))
        end
        clicOn(17,"3016",delay) -- ENTER
        
        -- enter the coords
        clicOn(17,"3035",delay+10,-1) -- ICP_DATA_UP_DN_SW 0
        clicOn(17,"3035",delay+10,-1) -- ICP_DATA_UP_DN_SW 0

        for iii, digits in ipairs({v.lat,v.lon}) do
          for ii = 1,string.len(digits) do 
                local vv = string.sub(digits,ii,ii)
                if vv == "N" then 
                    clicOn(17,"3004",delay)
                elseif  vv == "S" then 
                    clicOn(17,"3010",delay)
                elseif vv == "E" then 
                    clicOn(17,"3008",delay)
                elseif vv == "W" then 
                    clicOn(17,"3006",delay)
                elseif (vv == "." or vv == "'"  or vv == '"' or vv == "°"  or vv == " ") then 
                else            
                    local position = tonumber(vv)
                    if position ~=nil then 
                        position = position+1
                        if (correspondance[position] ~= nil) then 
                            clicOn(17,correspondance[position],delay)
                        end
                    end
                end
            end
            clicOn(17,"3016",delay) -- ENTER
            clicOn(17,"3035",delay+10,-1)
        end

        for ii = 1,string.len(v.alt) do 
            local vv = string.sub(v.alt,ii,ii)
            local position = tonumber(vv)
            if position ~=nil then 
                position = position+1
                if (correspondance[position] ~= nil) then 
                    clicOn(17,correspondance[position],delay)
                end
            end
        end
        clicOn(17,"3016",delay)
        clicOn(17,"3034",delay+10)
        clicOn(17,"3034",delay+10)
        clicOn(17,"3034",delay+10)
        clicOn(17,"3034",delay+10)

    end


    clicOn(17,"3032",delay+10,-1)
    doLoadCoords = true

end
--==================================================================================
function loadInA10(start,waypoints)
    inputBuffer = {}

    local correspondances = {
        ['0']='3024',
        ['1']='3015',
        ['2']='3016',
        ['3']='3017',
        ['4']='3018',
        ['5']='3019',
        ['6']='3020',
        ['7']='3021',
        ['8']='3022',
        ['9']='3023',
        ['a']='3027',
        ['b']='3028',
        ['c']='3029',
        ['d']='3030',
        ['e']='3031',
        ['f']='3032',
        ['g']='3033',
        ['h']='3034',
        ['i']='3035',
        ['j']='3036',
        ['k']='3037',
        ['l']='3038',
        ['m']='3039',
        ['n']='3040',
        ['o']='3041',
        ['p']='3042',
        ['q']='3043',
        ['r']='3044',
        ['s']='3045',
        ['t']='3046',
        ['u']='3047',
        ['v']='3048',
        ['w']='3049',
        ['x']='3050',
        ['y']='3051',
        ['z']='3052',
    }

    -- go to the CDU screen, WPT Page
    for _, v in ipairs(waypoints) do
      if v.des ~= '#' then
        log('v.des: '..v.des) 
        for k = 1, v.des:len() do 
          clicOn(9,correspondances[v.des:sub(k,k)])
        end
        clicOn(9,'3001') --CDU_LSK_3L
      else
        log('No v.des')         
        clicOn(9,'3007')  -- CDU_LSK_7R        
      end

      if v.name:len()  > 0 then
        log('v.name: '..v.name) 
        for i = 1, v.name:len()  do 
          vv = v.name:sub(i,i)
          local value = string.lower(vv)
          clicOn(9,correspondances[value])
        end
        clicOn(9,'3005') -- CDU_LSK_3R"
      end

        for iii, digits in ipairs({v.lat,v.lon,v.alt}) do
          if iii == 1 then --lat
            log('v.lat: '..v.lat) 
          elseif iii == 2 then
            log('v.lon: '..v.lon) 
          else
            log('v.alt: '..v.alt)            
          end       

        
        for ii = 1,string.len(digits) do 
            local vv = string.sub(digits,ii,ii)
            if vv == "N" then 
                clicOn(9,'3040')
            elseif  vv == "S" then 
                clicOn(9,'3045')
            elseif  vv == "E" then
                clicOn(9,'3031')
            elseif  vv == "W" then
                clicOn(9,'3049')
            elseif (vv == '"' or vv == "°"  or vv == " " or vv == "." or vv == "'") then
            else
                local position = tonumber(vv)
                if position ~=nil then 
                    if (correspondances[tostring(position)] ~= nil) then 
                        clicOn(9,correspondances[tostring(position)])
                    end
                end
            end 
        end
        if iii == 1 then --lat
          clicOn(9,'3003') --CDU_LSK_7L
        elseif iii == 2 then --lon
          clicOn(9,'3004')--CDU_LSK_9L
        else -- alt
          clicOn(9,'3002')--CDU_LSK_5L            
        end
      end
      -- alt!
    end
    doLoadCoords = true

end
--==================================================================================       
function loadInApache(StartWaypoint,Waypoints,Seat)
  log('Apache 1')
  inputBuffer = {}  
  local devices = {}
  local keys = {}
  local MPD = Seat..'_LMPD'
  local KU = Seat..'_KU'

  do -- mapping
    devices['PLT_LMPD'] = 42
    devices['CPG_LMPD'] = 44
    devices['PLT_KU'] = 29
    devices['CPG_KU'] = 30

    keys['TSD'] = {code = '3029', delay = 15}
    keys['B6'] 	= {code = '3013', delay = 15}
    keys['L1'] 	= {code = '3024', delay = 15}
    keys['L2'] 	= {code = '3023', delay = 15}
    keys['L3'] 	= {code = '3022', delay = 15}
    keys['L4'] 	= {code = '3021', delay = 15}
    keys['L5'] 	= {code = '3020', delay = 15}
    keys['L6'] 	= {code = '3019', delay = 15}

    keys['A'] 		= {code = '3007', delay = 15}
    keys['B'] 		= {code = '3008', delay = 15}
    keys['C'] 		= {code = '3009', delay = 15}
    keys['D'] 		= {code = '3010', delay = 15}
    keys['E'] 		= {code = '3011', delay = 15}
    keys['F'] 		= {code = '3012', delay = 15}
    keys['G'] 		= {code = '3013', delay = 15}
    keys['H'] 		= {code = '3014', delay = 15}
    keys['I'] 		= {code = '3015', delay = 15}
    keys['J'] 		= {code = '3016', delay = 15}
    keys['K'] 		= {code = '3017', delay = 15}
    keys['L'] 		= {code = '3018', delay = 15}
    keys['M'] 		= {code = '3019', delay = 15}
    keys['N'] 		= {code = '3020', delay = 15}
    keys['O'] 		= {code = '3021', delay = 15}
    keys['P'] 		= {code = '3022', delay = 15}
    keys['Q'] 		= {code = '3023', delay = 15}
    keys['R'] 		= {code = '3024', delay = 15}
    keys['S'] 		= {code = '3025', delay = 15}
    keys['T'] 		= {code = '3026', delay = 15}
    keys['U'] 		= {code = '3027', delay = 15}
    keys['V'] 		= {code = '3028', delay = 15}
    keys['W'] 		= {code = '3029', delay = 15}
    keys['X'] 		= {code = '3030', delay = 15}
    keys['Y'] 		= {code = '3031', delay = 15}
    keys['Z'] 		= {code = '3032', delay = 15}
    keys['0'] 		= {code = '3043', delay = 15}
    keys['1'] 		= {code = '3033', delay = 15}
    keys['2'] 		= {code = '3034', delay = 15}
    keys['3'] 		= {code = '3035', delay = 15}
    keys['4'] 		= {code = '3036', delay = 15}
    keys['5'] 		= {code = '3037', delay = 15}
    keys['6'] 		= {code = '3038', delay = 15}
    keys['7'] 		= {code = '3039', delay = 15}
    keys['8'] 		= {code = '3040', delay = 15}
    keys['9'] 		= {code = '3041', delay = 15}
    keys['-'] 		= {code = '3047', delay = 15}   
    keys['CLR'] 	= {code = '3001', delay = 15}
    keys['ENTER'] = {code = '3006', delay = 15}  
    keys[' ']     = {code = '3003', delay = 15} 
    keys['.'] 		= {code = '3042', delay = 15}         
  end -- maping
  
  --set Right MPD
  clicOn(devices[MPD],keys['TSD'].code ,keys['TSD'].delay)  
  clicOn(devices[MPD],keys['B6'].code ,keys['B6'].delay)  
  -- Process waypoints
  log('Apache 2')
  for _,v in pairs(Waypoints) do
    log('Apache v.des:<'..v.des..'>')
    clicOn(devices[MPD],keys['L2'].code ,keys['L2'].delay)  -- ADD
    local identType = 'W'
    local ident = 'WP'
    if string.upper(v.des) == '#' or string.upper(v.des) == 'W' then
      ident = 'WP'
      identType = 'W'
    elseif string.upper(v.des) == 'T' then
      ident = 'TG'     
      identType = 'T'
    elseif string.upper(v.des) == 'C' then
      ident = 'CP'   
      identType = 'C'
    elseif string.upper(v.des) == 'H' then
      ident = 'TU'  
      identType = 'H'
    elseif string.len(v.des) == 2  then
      ident = string.sub(string.upper(v.des),2,2)
      identType = 'W'
    elseif string.len(v.des) >= 3 then
      ident = string.sub(string.upper(v.des),2,3)
      identType = string.sub(string.upper(v.des),1,1)
    end
    log('Apache ident:<'..ident..'>')
    log('Apache identType:<'..identType..'>')
    if identType == 'W' then
       clicOn(devices[MPD],keys['L3'].code ,keys['L3'].delay,nil,'L3')  -- IDENT
    elseif identType == 'H' then
       clicOn(devices[MPD],keys['L4'].code ,keys['L4'].delay,nil,'L4')  -- IDENT
    elseif identType == 'C' then  
       clicOn(devices[MPD],keys['L5'].code ,keys['L5'].delay,nil,'L5')  -- IDENT
    elseif identType == 'T' then
      clicOn(devices[MPD],keys['L6'].code ,keys['L6'].delay,nil,'L6')  -- IDENT
    end

    clicOn(devices[MPD],keys['L1'].code ,keys['L1'].delay)  -- IDENT
    for i = 1,string.len(ident) do
      local K = string.sub(ident,i,i)
      clicOn(devices[KU],keys[K].code ,keys[K].delay)    
    end
    clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay) -- for ident
    log('v.free:<'..v.free..'>')
    if v.free ~='' then
      for i = 1,string.len(v.free ) do
        local K = string.upper(string.sub(v.free,i,i))
        if keys[K] then
          clicOn(devices[KU],keys[K].code ,keys[K].delay)    
        else
          log('Apache key:"'..K..'" ignored')
        end
      end
    end
    clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay) -- for free
    clicOn(devices[KU],keys['CLR'].code ,keys['CLR'].delay) -- clear UTM
    for i = 1,string.len(v.mgrs) do
      local K = string.upper(string.sub(v.mgrs,i,i))
      clicOn(devices[KU],keys[K].code ,keys[K].delay)    
    end
    clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay) -- for UTM
    clicOn(devices[KU],keys['CLR'].code ,keys['CLR'].delay) -- clear ALT 
    for i = 1,string.len(v.alt) do
      local K = string.upper(string.sub(v.alt,i,i))
      clicOn(devices[KU],keys[K].code ,keys[K].delay)    
    end   
     clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay) -- for ALT   
  end --for i,v in pairs(waypoints) do
  doLoadCoords = true
end -- function loadInApache
--==================================================================================       
function loadInKW(StartWaypoint,Waypoints,Seat)
  log('Kiowa Warrior 1')
  inputBuffer = {}  
  local devices = {}
  local keys = {}
  local MPD = Seat..'_MFD'
  local KU = 'MFK'

  do -- mapping
    devices['PLT_MFD'] = 11
    devices['CPG_MFD'] = 23
    devices['MFK'] = 14 
    local base_delay = 25
    keys['B2'] = {code = '3009', delay = base_delay}
    keys['R2'] = {code = '3014', delay = base_delay}
    keys['L1'] = {code = '3001', delay = base_delay}      
    keys['L2'] = {code = '3002', delay = base_delay}       
    keys['L4'] = {code = '3004', delay = base_delay}    
    keys['R5'] = {code = '3017', delay = base_delay}  
    keys['R4'] = {code = '3016', delay = base_delay}     
    keys['ENTER'] = {code = '3089', delay = base_delay}     
    keys['CLR'] = {code = '3091', delay = base_delay}         

    local alpha = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    local base = 3052
    local l = string.len(alpha)
    for i =1,l do
      local c = string.sub(alpha,i,i)
      base = base + 1
      keys[c] = {code = tostring(base), delay = base_delay}  
    end
  end -- maping
  
  -- Process waypoints
  log('Kiowa Warrior 2')
  
  for _,v in pairs(Waypoints) do    
    --set MPD
    log('Kiowa Warrior - Starting')
    clicOn(devices[MPD],keys['B2'].code ,keys['B2'].delay,nil,'B2')   
    clicOn(devices[MPD],keys['R2'].code ,keys['R2'].delay,nil,'R2')       
    local pointType = ''
    local pointNumber = ''
    if v.des == '#' or v.des == '##' or v.des == '###' then
      pointType = 'W'
    else
      local L = string.len(v.des)      
      if L == 1 and (string.upper(v.des) == 'W' or string.upper(v.des) == 'C' or string.upper(v.des) == 'T') then
        pointType = string.upper(v.des)    
      else
        pointType = string.upper(string.sub(v.des,L,L)) 
        local tmp =  string.upper(string.sub(v.des,1,L-1))
        if tmp ~= '##' then
          pointNumber = tmp 
        end
      end --if L == 1 and (string.upper(v.des) == 'W' or string.upper(v.des) == 'C' or string.upper(v.des) == 'T')
    end  -- if v.des == '#' or v.des == '##' or v.des == '###' then
    -- set point type
    log('Kiowa Warrior - Point type')
    if pointType == 'W' then
      clicOn(devices[MPD],keys['L4'].code ,keys['L4'].delay,nil,'L4') 
    elseif pointType == 'C' then
      clicOn(devices[MPD],keys['R2'].code ,keys['R2'].delay,nil,'R2') 
      clicOn(devices[MPD],keys['R5'].code ,keys['R5'].delay,nil,'R5')       
    elseif pointType == 'T' then
      clicOn(devices[MPD],keys['R4'].code ,keys['R4'].delay,nil,'R4') 
      clicOn(devices[MPD],keys['L1'].code ,keys['L1'].delay,nil,'L1')       
    end
    -- enter point id
    log('Kiowa Warrior - point id')
    if pointNumber ~= '' then
      clicOn(devices[KU],keys['CLR'].code ,keys['CLR'].delay,nil,'CLR') 
      local l = string.len(pointNumber)
      for i = 1,l do 
        local c = string.upper(string.sub(pointNumber,i,i)) 
        clicOn(devices[KU],keys[c].code ,keys[c].delay,nil,c) 
      end
      clicOn(devices[KU],keys[pointType].code ,keys[pointType].delay,nil,pointType) 
    end
    clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay,nil,'ENTER') 
    -- enter grid
    log('Kiowa Warrior - grid')    
    if pointType == 'T' then
      clicOn(devices[MPD],keys['L2'].code ,keys['L2'].delay,nil,'L2')          
    end
    clicOn(devices[KU],keys['CLR'].code ,keys['CLR'].delay,nil,'CLR')     
    for i = 1,string.len(v.mgrs) do
      local K = string.upper(string.sub(v.mgrs,i,i))
      clicOn(devices[KU],keys[K].code ,keys[K].delay,nil,K)    
    end
    clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay,nil,'ENTER') -- for UTM 
    -- enter alt
    log('Kiowa Warrior - alt')    
    clicOn(devices[KU],keys['CLR'].code ,keys['CLR'].delay,nil,'CLR')  
    for i = 1,string.len(v.alt) do
      local K = string.upper(string.sub(v.alt,i,i))
      clicOn(devices[KU],keys[K].code ,keys[K].delay,nil,K)    
    end   
     clicOn(devices[KU],keys['ENTER'].code ,keys['ENTER'].delay,nil,'ENTER') -- for ALT      
    -- store and set for next point
    log('Kiowa Warrior - store')    
    clicOn(devices[MPD],keys['R5'].code ,keys['R5'].delay,nil,'R5') -- 
  end-- for
  doLoadCoords = true
end -- function loadInApacheKW
--==================================================================================
function loadInF1EE(start,waypoints)
    local delay = 10
    local keys = {}
    keys['1'] = 3698
    keys['2'] = 3699 -- N
    keys['3'] = 3700
    keys['4'] = 3701 -- W
    keys['5'] = 3702
    keys['6'] = 3703 -- E
    keys['7'] = 3704
    keys['8'] = 3705 -- S
    keys['9'] = 3706
    keys['0'] = 3697
    keys['INSER'] = 3711
    keys['MODE'] = 3692
    keys['PARAM'] = 3690
    keys['WAYPOINT'] = 3694
    
    inputBuffer = {}
    log('>>>>>>>>>>>>> F1EE Load Start <<<<<<<<<<<<<<')
    clicOn(1,keys['MODE'],delay, 0.1)
    clicOn(1,keys['PARAM'],delay,0)    
    for i, v in ipairs(waypoints) do  
      for iii, digits in ipairs({v.lat,v.lon}) do
        for ii = 1,string.len(digits) do 
            local vv = string.sub(digits,ii,ii)
            if vv == "N" then 
              clicOn(1,keys['2'],delay)  
            elseif vv == "E" then
              clicOn(1,keys['6'],delay)  
            elseif vv == "S" then
              clicOn(1,keys['8'],delay)  
            elseif vv == "W" then
              clicOn(1,keys['4'],delay)  
            elseif (vv == "."  or vv == '"' or vv == "°"  or vv == " " or vv == "'") then 
            else
              local position = tonumber(vv)
              if position ~=nil then 
                clicOn(1,keys[vv],delay)
              end
            end
          end -- for ii
        clicOn(1,keys['INSER'],delay)  
      end -- for iii
      clicOn(1,keys['WAYPOINT'],delay,0.111)    
    end 

    doLoadCoords = true
end
--==================================================================================       
function loadInHook(StartWaypoint,Waypoints,Seat)
  log('Hool 1')
  inputBuffer = {}  
  local devices = {}
  local keys = {}
  local CDU = 'CDU_'..Seat

  do -- mapping
    devices["CDU_LEFT"] = 2
    devices["CDU_RIGHT"] = 3
    keys['FPLN'] = {code = 3071, delay = 15}
    keys['LSK_L3'] = {code = 3052, delay = 15}
    keys['N'] = {code = 3036, delay = 15}
    keys['E'] = {code = 3027, delay = 15}
    keys['S'] = {code = 3041, delay = 15}
    keys['W'] = {code = 3045, delay = 15}    
    keys['1'] = {code = 3011, delay = 15}
    keys['2'] = {code = 3012, delay = 15}
    keys['3'] = {code = 3013, delay = 15}
    keys['4'] = {code = 3014, delay = 15}
    keys['5'] = {code = 3015, delay = 15}
    keys['6'] = {code = 3016, delay = 15}
    keys['7'] = {code = 3017, delay = 15}
    keys['8'] = {code = 3018, delay = 15}
    keys['9'] = {code = 3019, delay = 15}
    keys['0'] = {code = 3010, delay = 15}
    keys['.'] = {code = 3020, delay = 15}     
--    keys['FPLN'] = {code = 3002, delay = 15}
--    keys['LSK_L3'] = {code = 3010, delay = 15}
--    keys['N'] = {code = 3056, delay = 15}
--    keys['E'] = {code = 3047, delay = 15}
--    keys['1'] = {code = 3030, delay = 15}
--    keys['2'] = {code = 3031, delay = 15}
--    keys['3'] = {code = 3032, delay = 15}
--    keys['4'] = {code = 3033, delay = 15}
--    keys['5'] = {code = 3034, delay = 15}
--    keys['6'] = {code = 3035, delay = 15}
--    keys['7'] = {code = 3036, delay = 15}
--    keys['8'] = {code = 3037, delay = 15}
--    keys['9'] = {code = 3038, delay = 15}
--    keys['0'] = {code = 3039, delay = 15}
--    keys['.'] = {code = 3040, delay = 15}     

  end -- maping
  
  -- Process waypoints
  clicOn(devices[CDU],keys['FPLN'].code ,keys['FPLN'].delay,nil,'FPLN')   
  local nwp = #Waypoints
  log('Hook 2. NWP: '..nwp)  
  for w = nwp,1,-1 do
    local v = Waypoints[w]
    --ignore v.des for now
    local info = v.lat..v.lon
    local l = string.len(info)
    for i =1,l do
      local c = string.sub(info,i,i)
      if keys[c] then
        clicOn(devices[CDU],keys[c].code ,keys[c].delay,nil,c) 
      end
    end
    clicOn(devices[CDU],keys['LSK_L3'].code ,keys['LSK_L3'].delay,nil,'LSK_L3')   
  end

  doLoadCoords = true
end -- function loadInApacheKW
--==================================================================================
function loadInH60(start, waypoints)
  local delay = 5  
  inputBuffer = {}
  local device = 26 -- AN/ASN-128 Doppler/GPS Navigation Set
  local compliantName = ''

    local keys = {
    ['1']=			{LTR= nil,  KEY='3242'},-- AN/ASN-128B Btn 1
    ['2']=			{LTR= nil,  KEY='3243'},-- AN/ASN-128B Btn 2
    ['3']=			{LTR= nil,  KEY='3244'},-- AN/ASN-128B Btn 3
    ['4']=			{LTR= nil,  KEY='3246'},-- AN/ASN-128B Btn 4
    ['5']=			{LTR= nil,  KEY='3247'},-- AN/ASN-128B Btn 5
    ['6']=			{LTR= nil,  KEY='3248'},-- AN/ASN-128B Btn 6
    ['7']=			{LTR= nil,  KEY='3250'},-- AN/ASN-128B Btn 7
    ['8']=			{LTR= nil,  KEY='3251'},-- AN/ASN-128B Btn 8
    ['9']=			{LTR= nil,  KEY='3252'},-- AN/ASN-128B Btn 9
    ['0']=			{LTR= nil,  KEY='3255'},-- AN/ASN-128B Btn 0
    
    ['DispSel']={LTR= nil,  KEY='3236'}, -- AN/ASN-128B Display Selector
    ['ModSel']=	{LTR= nil,  KEY='3235'}, -- AN/ASN-128B Mode Selector
    ['KYBD']=		{LTR= nil,  KEY='3237'}, -- AN/ASN-128B Btn KYBD
    ['LTR_L']=	{LTR= nil,  KEY='3238'}, -- AN/ASN-128B Btn LTR LEFT
    ['LTR_M']=	{LTR= nil,  KEY='3239'}, -- AN/ASN-128B Btn LTR MID
    ['LTR_R']=	{LTR= nil,  KEY='3240'}, -- AN/ASN-128B Btn LTR RIGHT
    ['F1']=			{LTR= nil,  KEY='506'}, -- AN/ASN-128B Btn F1
    ['TGT_S']=	{LTR= nil,  KEY='510'}, -- AN/ASN-128B Btn TGT STR
    ['INC']=		{LTR= nil,  KEY='3249'}, -- AN/ASN-128B Btn INC
    ['DEC']=		{LTR= nil,  KEY='3253'}, -- AN/ASN-128B Btn DEC
    ['CLR']=		{LTR= nil,  KEY='3254'}, -- AN/ASN-128B Btn CLR
    ['ENT']=		{LTR= nil,  KEY='3256'}, -- AN/ASN-128B Btn ENT
    
    ['A']=			{LTR='3238', KEY='3242'}, --1 LTR L Keys
    ['D']=			{LTR='3238', KEY='3243'}, --2 LTR L Keys
    ['G']=			{LTR='3238', KEY='3244'}, --3 LTR L Keys
    ['J']=			{LTR='3238', KEY='3246'}, --4 LTR L Keys
    ['M']=			{LTR='3238', KEY='3247'}, --5 LTR L Keys
    ['P']=			{LTR='3238', KEY='3248'}, --6 LTR L Keys
    ['S']=			{LTR='3238', KEY='3250'}, --7 LTR L Keys
    ['V']=			{LTR='3238', KEY='3251'}, --8 LTR L Keys
    ['Y']=			{LTR='3238', KEY='3252'}, --9 LTR L Keys
    
    ['B']=			{LTR='3239', KEY='3242'}, --1 LTR M keys
    ['E']=			{LTR='3239', KEY='3243'}, --2 LTR M keys
    ['H']=			{LTR='3239', KEY='3244'}, --3 LTR M keys
    ['K']=			{LTR='3239', KEY='3246'}, --4 LTR M keys
    ['N']=			{LTR='3239', KEY='3247'}, --5 LTR M keys
    ['Q']=			{LTR='3239', KEY='3248'}, --6 LTR M keys
    ['T']=			{LTR='3239', KEY='3250'}, --7 LTR M keys
    ['W']=			{LTR='3239', KEY='3251'}, --8 LTR M keys
    ['Z']=			{LTR='3239', KEY='3252'}, --9 LTR M keys
    ['#']=			{LTR='3239', KEY='3255'}, --0 LTR M keys
    
    ['C']=			{LTR='3240', KEY='3242'}, --1 LTR R Keys
    ['F']=			{LTR='3240', KEY='3243'}, --2 LTR R Keys
    ['I']=			{LTR='3240', KEY='3244'}, --3 LTR R Keys
    ['L']=			{LTR='3240', KEY='3246'}, --4 LTR R Keys
    ['O']=			{LTR='3240', KEY='3247'}, --5 LTR R Keys
    ['R']=			{LTR='3240', KEY='3248'}, --6 LTR R Keys
    ['U']=			{LTR='3240', KEY='3250'}, --7 LTR R Keys
    ['X']=			{LTR='3240', KEY='3251'}, --8 LTR R Keys
    ['*']=			{LTR='3240', KEY='3252'}, --9 LTR R Keys
    }

  local function Typevalue(keytopress)
    if keys[keytopress] then
      if keys[keytopress].LTR ~= nil then
        clicOn(device, keys[keytopress].LTR, delay)
        clicOn(device, keys[keytopress].KEY, delay)
      elseif (keys[keytopress].LTR =='' or keys[keytopress].LTR == nil) then
        clicOn(device, keys[keytopress].KEY, delay)
      else
        log('nothing to do here')
      end
    else
      log('key ' .. keytopress .. ' does not exist')
    end
  end

  clicOn(device, 3236, delay, 0.04) -- set Display Sel to DST/BRG (reset)
  clicOn(device, 3236, delay, 0.05) -- set Display Sel to WP/TGT
  clicOn(device, 3235, delay, 0.04) -- set Mode Sel to LAT LON

  for _,v in pairs(waypoints) do 

    clicOn(device, keys['INC'].KEY, delay)  -- Select the next waypoint on the AN/ASN 128B

    if v.name or v.name == '' then -- check if a name exists OR not... 
      if(v.name:len() <= 13) then 
        v.name=v.name
      elseif v.name:len() > 13 then -- check if the name is more than 13 digits
        v.name=v.name:sub(1, 13) --shortens it to 13
      end
    end

    local function typeValueOnANASN128B(value)
      clicOn(device, keys['KYBD'].KEY, delay)  -- Select the next field on the AN/ASN 128B
      for i = 1, value:len() do
        local char = value:sub(i, i)
        local upperChar = string.upper(char)
        Typevalue(tostring(upperChar))
      end
    end

    typeValueOnANASN128B(v.name) -- type the name on the AN/ASN 128B
    typeValueOnANASN128B(v.lat) -- type the latitude on the AN/ASN 128B
    typeValueOnANASN128B(v.lon) -- type the longitude on the AN/ASN 128B


    clicOn(device, keys['ENT'].KEY, delay)  -- Select the next field on the AN/ASN 128B -- Should be Out to the next
  end 
  clicOn(device, 3236, delay, 0.04) -- set Display Sel to DST/BRG (nav)
  doLoadCoords = true
end -- function
--==================================================================================
function loadInGazelle(start,waypoints)
  
    local NADIR = 22 
    local delay = 25
    local keys = {}
    keys['1'] = 3010
    keys['2'] = 3011 
    keys['N'] = 3011 
    keys['3'] = 3012
    keys['4'] = 3013 
    keys['W'] = 3013 
    keys['5'] = 3014
    keys['6'] = 3015 
    keys['E'] = 3015    
    keys['7'] = 3016
    keys['8'] = 3017 
    keys['S'] = 3017     
    keys['9'] = 3018
    keys['0'] = 3009
    keys['ENT'] = 3004
    keys['EFF'] = 3023
    keys['DOWN'] = 3008

    local function EFF(n)
      for d =1,n do        
        clicOn(NADIR,keys['EFF'],delay,nil,'EFF')
        clicOn(-1,-1,10,nil,'WAIT') -- dummy device to wait for EFF to work
      end        
    end

    
    inputBuffer = {}
    log('>>>>>>>>>>>>> Gazelle Load Start <<<<<<<<<<<<<<')
    
    local wpc = start
    log('start: '..wpc)
    local wp = 0 
    for _, v in pairs(waypoints) do  
      if v.des == '#' then
        wp = wpc
        wpc = wpc + 1
      else
        wp = v.des
      end  
      log('waypoint: '..wp)
      local w = tostring(wp)
      clicOn(NADIR,keys[w],delay,nil,w)  
      clicOn(NADIR,keys['ENT'],delay,nil,'ENT')  
      EFF(6)
      local L = string.len(v.lat)
      for i = 1,L do
        local k = string.sub(v.lat,i,i)
        if keys[k]then 
          clicOn(NADIR,keys[k],delay,nil,k)              
        end
      end
      clicOn(NADIR,keys['DOWN'],delay,nil,'DOWN')   
      EFF(7)
      L = string.len(v.lon)
      for i = 1,L do
        local k = string.sub(v.lon,i,i)
        if keys[k] then 
          clicOn(NADIR,keys[k],delay,nil,k)              
        end
      end
      clicOn(NADIR,keys['ENT'],delay,nil,'ENT')  
    end 
    doLoadCoords = true
end -- function
--==================================================================================
function  loadInBlackShark(start,waypoints)
    local NC = 0
    local TC = start-1
    local AC = 0
    local FC = 0
    local PVI = 20 
    local delay = 25
    local keys = {}
    
    keys['1'] = 3002
    keys['2'] = 3003 
    keys['3'] = 3004
    keys['4'] = 3005 
    keys['5'] = 3006
    keys['6'] = 3007   
    keys['7'] = 3008
    keys['8'] = 3009   
    keys['9'] = 3010
    keys['0'] = 3001
    
    keys['N'] = 3001     
    keys['S'] = 3002  
    keys['E'] = 3001   
    keys['W'] = 3002  
    
    keys['ENTER'] = 3018 
    keys['WPT'] = 3011 
    keys['FIX'] = 3013
    keys['AF'] = 3015
    keys['TGT'] = 3017
    keys['MODE'] = 3026
  log('>>>>>>>>>>>>> Blackshark Load Start <<<<<<<<<<<<<<')
  clicOn(PVI, keys['MODE'], delay, 0.2, 'MODE ENT' )
  for _, v in pairs(waypoints) do  
    local wType = ''
    local wNun = 0
    local L = string.len(v.des)
    if L == 1 then
      if v.des == '#' or v.des == 'T' then
        TC = TC + 1
        wNum = tostring(TC)
        wType = 'T'
      elseif v.des == 'N' then
        NC = NC + 1
        wNum = tostring(NC)
        wType = 'N'     
      elseif v.des == 'A' then
        AC = AC + 1
        wNum = tostring(AC)
        wType = 'A'      
      elseif v.des == 'F' then
        FC = FC + 1
        wNum = tostring(FC)
        wType = 'F'      
      elseif string.find('123456789',v.des) then
        wNum = v.des
        wType = 'T'   
      end
    else
      wType = string.sub(v.des,1,1)
      wNum = string.sub(v.des,2,2)
    end
    log('loading: '..wType..wNum)
    local btnT = ''
    if wType == 'T' then
      btnT = 'TGT'
    elseif wType == 'N' then
      btnT = 'WPT'
    elseif wType == 'F' then
      btnT = 'FIX'   
    elseif wType == 'A' then
      btnT = 'AF'   
    end 
    clicOn(PVI,keys[btnT],delay,nil,btnT)     
    clicOn(PVI,keys[wNum],delay,nil,wNum)      
    L = string.len(v.lat)
    for i = 1,L do
      local k = string.sub(v.lat,i,i)
      if keys[k]then 
        clicOn(PVI,keys[k],delay,nil,k)              
      end
    end    
    L = string.len(v.lon)
    for i = 1,L do
      local k = string.sub(v.lon,i,i)
      if keys[k]then 
        clicOn(PVI,keys[k],delay,nil,k)              
      end
    end  
    clicOn(PVI,keys['ENTER'],delay,nil,'ENTER') 
    clicOn(PVI,keys[btnT],delay,nil,btnT)         
  end --for _, v in pairs(waypoints) do  
  clicOn(PVI, keys['MODE'], delay, 0.3, 'MODE OPER' )
  doLoadCoords = true
end -- function
--==================================================================================
function  loadInViggen(start,waypoints)
  local WP_Count = start-1
  local NAV = 12
  local NAVPANEL = 23
  local delay = 10
  local keys = {}
  keys['IN/OUT Switch'] = 3008
  keys['Datapanel Selector'] = 3009
  keys['0'] = 3020
  keys['1'] = 3021
  keys['2'] = 3022
  keys['3'] = 3023
  keys['4'] = 3024
  keys['5'] = 3025
  keys['6'] = 3026
  keys['7'] = 3027
  keys['8'] = 3028
  keys['9'] = 3029 
  keys['B1'] = 3011
  keys['B2'] = 3012
  keys['B3'] = 3013
  keys['B4'] = 3014
  keys['B5'] = 3015
  keys['B6'] = 3016
  keys['B7'] = 3017
  keys['B8'] = 3018
  keys['B9'] = 3019
  keys['RENSA'] = 3001
  keys['RENSA_COVER'] = 3101
  
  log('>>>>>>>>>>>>> Viggen Load Start <<<<<<<<<<<<<<')
--  clicOn(NAVPANEL,keys['RENSA_COVER'], delay, nil, 'Open RENSA Cover' ) 
--  clicOn(NAVPANEL,keys['RENSA'], delay, nil, 'Clear WP data' ) 
--  clicOn(NAVPANEL,keys['RENSA_COVER'], delay, nil, 'Close RENSA Cover' )   
  for _, v in pairs(waypoints) do    
    local wType = 'B'
    local wNum = 0
    local L = string.len(v.des)
    if L == 1 then
      if v.des == '#' then
        WP_Count = WP_Count + 1
        wNum = WP_Count
      else
        wNum = tonumber(v.des)
      end
    elseif L == 2 then
      wType = string.sub(v.des,1,1)
      if wType == 'B' or wType == 'M' then
        if string.sub(v.des,2,2) == '#' then
          WP_Count = WP_Count + 1
          wNum = WP_Count      
        else
          wNum = tonumber(string.sub(v.des,2,2))
        end
      elseif wType == 'L' then
        wType = v.des
        wNum = 0
      end
    end
    --log('loading: '..wType..wNum)
    local btn = ''
    if wType == 'B' or wType == 'M' then
      clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.5, 'Set To REF/LOLA' ) 
      clicOn(NAVPANEL,keys['IN/OUT Switch'], delay, 0.95, 'Set To INPUT' ) 
      btn = 'B'..wNum
      local S = v.lon..v.lat
      L = string.len(S)
      for i = 1,L do
        local k = string.sub(S,i,i)
        if keys[k]then 
          clicOn(NAV,keys[k],delay,nil,k)              
        end
      end      
      clicOn(NAV,keys[btn],delay,nil,btn)  
      clicOn(NAVPANEL,keys['IN/OUT Switch'], delay,0.0, 'Set To OUTPUT' ) 
      clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.6, 'Set To AKT POS' )   
      -- done loading coords
      if wType == 'M' then -- target poit
        clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.1, 'Set To TAKT' ) 
        clicOn(NAVPANEL,keys['IN/OUT Switch'], delay, 0.95, 'Set To INPUT' ) 
        clicOn(NAV,keys['9'],delay,nil,'9')    
        clicOn(NAV,keys[btn],delay,nil,btn) 
        clicOn(NAVPANEL,keys['IN/OUT Switch'], delay, 0.0, 'Set To OUTPUT' ) 
        clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.6, 'Set To AKT POS' )   
      end
      if v.brg and v.rng then -- popoup point
        clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.1, 'Set To TAKT' ) 
        clicOn(NAVPANEL,keys['IN/OUT Switch'], delay, 0.95, 'Set To INPUT' ) 
        local S = v.brg..v.rng
        L = string.len(S)
        for i = 1,L do
          local k = string.sub(S,i,i)
          if keys[k]then 
            clicOn(NAV,keys[k],delay,nil,k)              
          end  
        end
        clicOn(NAV,keys[btn],delay,nil,btn)  
        clicOn(NAVPANEL,keys['IN/OUT Switch'], delay,0.0, 'Set To OUTPUT' )   
        clicOn(NAVPANEL,keys['Datapanel Selector'], delay, 0.6, 'Set To AKT POS' )   
       
      end   
    elseif wType == 'LS' or wType == 'L1' or wType == 'L2' then
      --[[
        L1 & L2  
            lon + lat + RWY Hdg(4digits)
            code 
            
      --]]
    end  --if wType == 'B' or wType == 'M' then
    
   
  end --for _, v in pairs(waypoints) do 
  doLoadCoords = true
end -- function    